package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.Obra;
import com.ejie.ab04b.model.solicitud.SolicObra;

/**
 * ObraDaoImpl generated by UDA, 22-feb-2017 8:54:47.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class ObraDaoImpl implements ObraDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.CODOBRA_082 CODOBRA082, t1.TIPOBR_082 TIPOBR082, t1.INDANX2_082 INDANX2082, t1.APDOANX2_082 APDOANX2082, t1.DESTRAB_082 DESTRAB082, t1.PRVOBR_082 PRVOBR082, t1.MUNOBR_082 MUNOBR082, t1.LOCOBR_082 LOCOBR082, t1.DIROBR_082 DIROBR082, t1.FECINI_082 FECINI082, t1.FECFIN_082 FECFIN082, t1.TEREXP_082 TEREXP082, t1.ANOEXP_082 ANOEXP082, t1.NUMEXP_082 NUMEXP082, t1.ORDEXP_082 ORDEXP082, t1.FECALT_082 FECALT082, t1.USUALT_082 USUALT082, t1.FECMOD_082 FECMOD082, t1.USUMOD_082 USUMOD082, t1.DESCOBR_082 DESCOBR082, t1.DESOBR_082 DESOBR082, t1.DURPRE_082 DURPRE082, t1.UNITMP_082 UNITMP082, t1.TRBHOM_082 TRBHOM082, t1.TRBMUJ_082 TRBMUJ082, t1.TRBTOT_082 TRBTOT082 FROM AB0482S00 t1";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Obra> rwMap = new RowMapper<Obra>() {
		public Obra mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Obra(resultSet.getLong("CODOBRA082"),
					resultSet.getString("TIPOBR082"),
					resultSet.getString("INDANX2082"),
					resultSet.getString("APDOANX2082"),
					resultSet.getString("DESTRAB082"),
					resultSet.getString("PRVOBR082"),
					resultSet.getString("MUNOBR082"),
					resultSet.getString("LOCOBR082"),
					resultSet.getString("DIROBR082"),
					resultSet.getDate("FECINI082"),
					resultSet.getDate("FECFIN082"),
					resultSet.getString("TEREXP082"),
					resultSet.getString("ANOEXP082"),
					resultSet.getInt("NUMEXP082"),
					resultSet.getLong("ORDEXP082"),
					resultSet.getDate("FECALT082"),
					resultSet.getString("USUALT082"),
					resultSet.getDate("FECMOD082"),
					resultSet.getString("USUMOD082"),
					resultSet.getString("DESCOBR082"),
					resultSet.getString("DESOBR082"),
					resultSet.getString("DURPRE082"),
					resultSet.getString("UNITMP082"),
					resultSet.getLong("TRBHOM082"),
					resultSet.getLong("TRBMUJ082"),
					resultSet.getLong("TRBTOT082"));
		}
	};

	private RowMapper<Obra> rwMapPK = new RowMapper<Obra>() {
		public Obra mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Obra(resultSet.getLong("CODOBRA082"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * dataSource DataSource
	 */
	private RowMapper<JerarquiaDto<Obra>> rwMapJerarquia = new RowMapper<JerarquiaDto<Obra>>() {
		public JerarquiaDto<Obra> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Obra ab0482s00 = new Obra(resultSet.getLong("CODOBRA082"),
					resultSet.getString("TIPOBR082"),
					resultSet.getString("INDANX2082"),
					resultSet.getString("APDOANX2082"),
					resultSet.getString("DESTRAB082"),
					resultSet.getString("PRVOBR082"),
					resultSet.getString("MUNOBR082"),
					resultSet.getString("LOCOBR082"),
					resultSet.getString("DIROBR082"),
					resultSet.getDate("FECINI082"),
					resultSet.getDate("FECFIN082"),
					resultSet.getString("TEREXP082"),
					resultSet.getString("ANOEXP082"),
					resultSet.getInt("NUMEXP082"),
					resultSet.getLong("ORDEXP082"),
					resultSet.getDate("FECALT082"),
					resultSet.getString("USUALT082"),
					resultSet.getDate("FECMOD082"),
					resultSet.getString("USUMOD082"),
					resultSet.getString("DESCOBR082"),
					resultSet.getString("DESOBR082"),
					resultSet.getString("DURPRE082"),
					resultSet.getString("UNITMP082"),
					resultSet.getLong("TRBHOM082"),
					resultSet.getLong("TRBMUJ082"),
					resultSet.getLong("TRBTOT082"));

			JerarquiaDto<Obra> jerarquia = new JerarquiaDto<Obra>();
			jerarquia.setModel(ab0482s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 * ab0482s00 Obra Obra
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the obra
	 */
	public Obra add(Obra ab0482s00) {
		String query = "INSERT INTO AB0482S00 (CODOBRA_082, TIPOBR_082, INDANX2_082, APDOANX2_082, DESTRAB_082, PRVOBR_082, MUNOBR_082, LOCOBR_082, DIROBR_082, FECINI_082, FECFIN_082, TEREXP_082, ANOEXP_082, NUMEXP_082, ORDEXP_082, FECALT_082, USUALT_082, FECMOD_082, USUMOD_082, DESCOBR_082, DESOBR_082, DURPRE_082, UNITMP_082, TRBHOM_082, TRBMUJ_082, TRBTOT_082) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		ab0482s00.setCodobra082(Secuencias.COD_OBRA_082
				.getNextLong(jdbcTemplate));

		this.jdbcTemplate.update(query, ab0482s00.getCodobra082(),
				ab0482s00.getTipobr082(), ab0482s00.getIndanx2082(),
				ab0482s00.getApdoanx2082(), ab0482s00.getDestrab082(),
				ab0482s00.getPrvobr082(), ab0482s00.getMunobr082(),
				ab0482s00.getLocobr082(), ab0482s00.getDirobr082(),
				ab0482s00.getFecini082(), ab0482s00.getFecfin082(),
				ab0482s00.getTerexp082(), ab0482s00.getAnoexp082(),
				ab0482s00.getNumexp082(), ab0482s00.getOrdexp082(),
				ab0482s00.getFecalt082(), ab0482s00.getUsualt082(),
				ab0482s00.getFecmod082(), ab0482s00.getUsumod082(),
				ab0482s00.getDescobr082(), ab0482s00.getDesobr082(),
				ab0482s00.getDurpre082(), ab0482s00.getUnitmp082(),
				ab0482s00.getTrbhom082(), ab0482s00.getTrbmuj082(),
				ab0482s00.getTrbtot082());

		return ab0482s00;
	}

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 * ab0482s00 Obra Obra
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the obra
	 */
	public Obra addPresencial(Obra ab0482s00) {
		String query = "INSERT INTO AB0482S00 (CODOBRA_082, TEREXP_082, ANOEXP_082, NUMEXP_082) VALUES (?,?,?,?)";

		ab0482s00.setCodobra082(Secuencias.COD_OBRA_082
				.getNextLong(jdbcTemplate));

		this.jdbcTemplate.update(query, ab0482s00.getCodobra082(),
				ab0482s00.getTerexp082(), ab0482s00.getAnoexp082(),
				ab0482s00.getNumexp082());

		return ab0482s00;
	}

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 * obra Obra solicitud Obra Obra
	 * 
	 * @param obra
	 *            the obra
	 * @param solicitud
	 *            the solicitud
	 * @return the obra
	 */
	public Obra addFromSolicitud(Obra obra, SolicObra solicitud) {
		String query = "INSERT INTO AB0482S00 (CODOBRA_082, TIPOBR_082, INDANX2_082, APDOANX2_082, DESTRAB_082, PRVOBR_082, MUNOBR_082, LOCOBR_082, DIROBR_082, FECINI_082, FECFIN_082, "
				+ "TEREXP_082, ANOEXP_082, NUMEXP_082, ORDEXP_082, FECALT_082, USUALT_082, FECMOD_082, USUMOD_082, DESCOBR_082, DESOBR_082, DURPRE_082, UNITMP_082, TRBHOM_082, TRBMUJ_082, TRBTOT_082) "
				+ "(SELECT ?, TIPOBR_082, INDANX2_082, APDOANX2_082, DESTRAB_082, PRVOBR_082, MUNOBR_082, LOCOBR_082, DIROBR_082, FECINI_082, FECFIN_082, "
				+ "?, ?, ?, ORDEXP_082, FECALT_082, USUALT_082, FECMOD_082, USUMOD_082, DESCOBR_082, DESOBR_082, DURPRE_082, UNITMP_082, TRBHOM_082, TRBMUJ_082, TRBTOT_082 "
				+ " FROM AB0482S01 WHERE CODOBRA_082 = ? )";

		obra.setCodobra082(Secuencias.COD_OBRA_082.getNextLong(jdbcTemplate));

		this.jdbcTemplate.update(query, obra.getCodobra082(),
				obra.getTerexp082(), obra.getAnoexp082(), obra.getNumexp082(),
				solicitud.getCodobra082());

		return obra;
	}

	/**
	 * Updates a single row in the Obra table.
	 * 
	 * ab0482s00 Obra Obra
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the obra
	 */
	public Obra update(Obra ab0482s00) {
		String query = "UPDATE AB0482S00 SET TIPOBR_082=?, INDANX2_082=?, APDOANX2_082=?, DESTRAB_082=?, PRVOBR_082=?, MUNOBR_082=?, LOCOBR_082=?, DIROBR_082=?, FECINI_082=?, FECFIN_082=?, TEREXP_082=?, ANOEXP_082=?, NUMEXP_082=?, ORDEXP_082=?, FECALT_082=?, USUALT_082=?, FECMOD_082=?, USUMOD_082=?, DESCOBR_082=?, DESOBR_082=?, DURPRE_082=?, UNITMP_082=?, TRBHOM_082=?, TRBMUJ_082=?, TRBTOT_082=? WHERE CODOBRA_082=?";
		this.jdbcTemplate.update(query, ab0482s00.getTipobr082(),
				ab0482s00.getIndanx2082(), ab0482s00.getApdoanx2082(),
				ab0482s00.getDestrab082(), ab0482s00.getPrvobr082(),
				ab0482s00.getMunobr082(), ab0482s00.getLocobr082(),
				ab0482s00.getDirobr082(), ab0482s00.getFecini082(),
				ab0482s00.getFecfin082(), ab0482s00.getTerexp082(),
				ab0482s00.getAnoexp082(), ab0482s00.getNumexp082(),
				ab0482s00.getOrdexp082(), ab0482s00.getFecalt082(),
				ab0482s00.getUsualt082(), ab0482s00.getFecmod082(),
				ab0482s00.getUsumod082(), ab0482s00.getDescobr082(),
				ab0482s00.getDesobr082(), ab0482s00.getDurpre082(),
				ab0482s00.getUnitmp082(), ab0482s00.getTrbhom082(),
				ab0482s00.getTrbmuj082(), ab0482s00.getTrbtot082(),
				ab0482s00.getCodobra082());
		return ab0482s00;
	}

	/**
	 * Updates a single row in the Obra table.
	 * 
	 * obra Obra Obra
	 * 
	 * @param obra
	 *            the obra
	 * @return the obra
	 */
	public Obra modificarObraTabDatosObra(Obra obra) {
		String query = "UPDATE AB0482S00 SET TIPOBR_082=?,FECINI_082=?,FECFIN_082=?,DURPRE_082=?,UNITMP_082=?,TRBHOM_082=?,TRBMUJ_082=?, TRBTOT_082=?, DESOBR_082=?,"
				+ "PRVOBR_082=?, MUNOBR_082=?, LOCOBR_082=?, DIROBR_082=?,INDANX2_082=?, APDOANX2_082=?,DESTRAB_082=?  WHERE CODOBRA_082=? ";
		this.jdbcTemplate.update(query, obra.getTipobr082(),
				obra.getFecini082(), obra.getFecfin082(), obra.getDurpre082(),
				obra.getUnitmp082(), obra.getTrbhom082(), obra.getTrbmuj082(),
				obra.getTrbtot082(), obra.getDesobr082(), obra.getPrvobr082(),
				obra.getMunobr082(), obra.getLocobr082(), obra.getDirobr082(),
				obra.getIndanx2082(), obra.getApdoanx2082(),
				obra.getDestrab082(), obra.getCodobra082());
		return obra;
	}

	/**
	 * Finds a single row in the Obra table.
	 * 
	 * ab0482s00 Obra Obra
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the obra
	 */
	@Transactional(readOnly = true)
	public Obra findByExpediente(Obra ab0482s00) {
		StringBuilder query = new StringBuilder(ObraDaoImpl.STRING_BUILDER_INIT);
		query.append(ObraDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.CODOBRA_082 = ? AND t1.ANOEXP_082  = ? AND t1.NUMEXP_082 = ? AND t1.TEREXP_082 = ?");

		List<Obra> ab0482s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, ab0482s00.getCodobra082(),
				ab0482s00.getAnoexp082(), ab0482s00.getNumexp082(),
				ab0482s00.getTerexp082());
		return (Obra) DataAccessUtils.uniqueResult(ab0482s00List);
	}

	/**
	 * Finds a single row in the Obra table.
	 * 
	 * ab0482s00 Obra Obra
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the obra
	 */
	@Transactional(readOnly = true)
	public Obra find(Obra ab0482s00) {
		StringBuilder query = new StringBuilder(ObraDaoImpl.STRING_BUILDER_INIT);
		query.append(ObraDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.CODOBRA_082 = ?  ");

		List<Obra> ab0482s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, ab0482s00.getCodobra082());
		return (Obra) DataAccessUtils.uniqueResult(ab0482s00List);
	}

	/**
	 * Removes a single row in the Obra table.
	 * 
	 * ab0482s00 Obra
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 */
	public void remove(Obra ab0482s00) {
		String query = "DELETE FROM AB0482S00 WHERE CODOBRA_082=?";
		this.jdbcTemplate.update(query, ab0482s00.getCodobra082());
	}

	/**
	 * Finds a list of rows in the Obra table.
	 * 
	 * ab0482s00 Obra jqGridRequestDto JQGridRequestDto List<Obra>
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Obra> findAll(Obra ab0482s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODOBRA_082 CODOBRA082,t1.TIPOBR_082 TIPOBR082,t1.INDANX2_082 INDANX2082,t1.APDOANX2_082 APDOANX2082,t1.DESTRAB_082 DESTRAB082,t1.PRVOBR_082 PRVOBR082,t1.MUNOBR_082 MUNOBR082,t1.LOCOBR_082 LOCOBR082,t1.DIROBR_082 DIROBR082,t1.FECINI_082 FECINI082,t1.FECFIN_082 FECFIN082,t1.TEREXP_082 TEREXP082,t1.ANOEXP_082 ANOEXP082,t1.NUMEXP_082 NUMEXP082,t1.ORDEXP_082 ORDEXP082,t1.FECALT_082 FECALT082,t1.USUALT_082 USUALT082,t1.FECMOD_082 FECMOD082,t1.USUMOD_082 USUMOD082,t1.DESCOBR_082 DESCOBR082,t1.DESOBR_082 DESOBR082,t1.DURPRE_082 DURPRE082,t1.UNITMP_082 UNITMP082,t1.TRBHOM_082 TRBHOM082,t1.TRBMUJ_082 TRBMUJ082,t1.TRBTOT_082 TRBTOT082 ");
		query.append("FROM AB0482S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0482s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Obra>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Obra table using like.
	 * 
	 * ab0482s00 Obra jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Obra>
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Obra> findAllLike(Obra ab0482s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODOBRA_082 CODOBRA082,t1.TIPOBR_082 TIPOBR082,t1.INDANX2_082 INDANX2082,t1.APDOANX2_082 APDOANX2082,t1.DESTRAB_082 DESTRAB082,t1.PRVOBR_082 PRVOBR082,t1.MUNOBR_082 MUNOBR082,t1.LOCOBR_082 LOCOBR082,t1.DIROBR_082 DIROBR082,t1.FECINI_082 FECINI082,t1.FECFIN_082 FECFIN082,t1.TEREXP_082 TEREXP082,t1.ANOEXP_082 ANOEXP082,t1.NUMEXP_082 NUMEXP082,t1.ORDEXP_082 ORDEXP082,t1.FECALT_082 FECALT082,t1.USUALT_082 USUALT082,t1.FECMOD_082 FECMOD082,t1.USUMOD_082 USUMOD082,t1.DESCOBR_082 DESCOBR082,t1.DESOBR_082 DESOBR082,t1.DURPRE_082 DURPRE082,t1.UNITMP_082 UNITMP082,t1.TRBHOM_082 TRBHOM082,t1.TRBMUJ_082 TRBMUJ082,t1.TRBTOT_082 TRBTOT082 ");
		query.append("FROM AB0482S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0482s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Obra>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Obra table.
	 * 
	 * ab0482s00 Obra Long
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Obra ab0482s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0482S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0482s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Obra table using like.
	 * 
	 * ab0482s00 Obra startsWith Boolean Long
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Obra ab0482s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0482S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0482s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Obra selected for rup_table.
	 * 
	 * ab0482s00 Obra jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Obra>>
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Obra>> reorderSelection(Obra ab0482s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODOBRA_082 CODOBRA082,t1.TIPOBR_082 TIPOBR082,t1.INDANX2_082 INDANX2082,t1.APDOANX2_082 APDOANX2082,t1.DESTRAB_082 DESTRAB082,t1.PRVOBR_082 PRVOBR082,t1.MUNOBR_082 MUNOBR082,t1.LOCOBR_082 LOCOBR082,t1.DIROBR_082 DIROBR082,t1.FECINI_082 FECINI082,t1.FECFIN_082 FECFIN082,t1.TEREXP_082 TEREXP082,t1.ANOEXP_082 ANOEXP082,t1.NUMEXP_082 NUMEXP082,t1.ORDEXP_082 ORDEXP082,t1.FECALT_082 FECALT082,t1.USUALT_082 USUALT082,t1.FECMOD_082 FECMOD082,t1.USUMOD_082 USUMOD082,t1.DESCOBR_082 DESCOBR082,t1.DESOBR_082 DESOBR082,t1.DURPRE_082 DURPRE082,t1.UNITMP_082 UNITMP082,t1.TRBHOM_082 TRBHOM082,t1.TRBMUJ_082 TRBMUJ082,t1.TRBTOT_082 TRBTOT082 ");
		// FROM
		query.append("FROM AB0482S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0482s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Obra.class, filterParamList,
				"CODOBRA_082");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Obra>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Obra searchParams Obra jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<TableRowDto<Obra>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Obra>> search(Obra filterParams, Obra searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODOBRA_082 CODOBRA082,t1.TIPOBR_082 TIPOBR082,t1.INDANX2_082 INDANX2082,t1.APDOANX2_082 APDOANX2082,t1.DESTRAB_082 DESTRAB082,t1.PRVOBR_082 PRVOBR082,t1.MUNOBR_082 MUNOBR082,t1.LOCOBR_082 LOCOBR082,t1.DIROBR_082 DIROBR082,t1.FECINI_082 FECINI082,t1.FECFIN_082 FECFIN082,t1.TEREXP_082 TEREXP082,t1.ANOEXP_082 ANOEXP082,t1.NUMEXP_082 NUMEXP082,t1.ORDEXP_082 ORDEXP082,t1.FECALT_082 FECALT082,t1.USUALT_082 USUALT082,t1.FECMOD_082 FECMOD082,t1.USUMOD_082 USUMOD082,t1.DESCOBR_082 DESCOBR082,t1.DESOBR_082 DESOBR082,t1.DURPRE_082 DURPRE082,t1.UNITMP_082 UNITMP082,t1.TRBHOM_082 TRBHOM082,t1.TRBMUJ_082 TRBMUJ082,t1.TRBTOT_082 TRBTOT082 ");
		// FROM
		query.append("FROM AB0482S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Obra.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CODOBRA_082");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Obra>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filterab0482s00 Obra jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * 
	 * @param filterab0482s00
	 *            the filterab 0482 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override()
	public void removeMultiple(Obra filterab0482s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODOBRA_082 CODOBRA082,t1.TIPOBR_082 TIPOBR082,t1.INDANX2_082 INDANX2082,t1.APDOANX2_082 APDOANX2082,t1.DESTRAB_082 DESTRAB082,t1.PRVOBR_082 PRVOBR082,t1.MUNOBR_082 MUNOBR082,t1.LOCOBR_082 LOCOBR082,t1.DIROBR_082 DIROBR082,t1.FECINI_082 FECINI082,t1.FECFIN_082 FECFIN082,t1.TEREXP_082 TEREXP082,t1.ANOEXP_082 ANOEXP082,t1.NUMEXP_082 NUMEXP082,t1.ORDEXP_082 ORDEXP082,t1.FECALT_082 FECALT082,t1.USUALT_082 USUALT082,t1.FECMOD_082 FECMOD082,t1.USUMOD_082 USUMOD082,t1.DESCOBR_082 DESCOBR082,t1.DESOBR_082 DESOBR082,t1.DURPRE_082 DURPRE082,t1.UNITMP_082 UNITMP082,t1.TRBHOM_082 TRBHOM082,t1.TRBMUJ_082 TRBMUJ082,t1.TRBTOT_082 TRBTOT082 ");
		// FROM
		query.append("FROM AB0482S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0482s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Obra.class, query,
						params, "CODOBRA_082");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Obra table.
	 * 
	 * filterObra Obra jqGridRequestDto JQGridRequestDto
	 * List<JerarquiaDto<Obra>>
	 * 
	 * @param filterObra
	 *            the filter obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override()
	public List<JerarquiaDto<Obra>> findAllLikeJerarquia(Obra filterObra,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CODOBRA_082 CODOBRA082,t1.TIPOBR_082 TIPOBR082,t1.INDANX2_082 INDANX2082,t1.APDOANX2_082 APDOANX2082,t1.DESTRAB_082 DESTRAB082,t1.PRVOBR_082 PRVOBR082,t1.MUNOBR_082 MUNOBR082,t1.LOCOBR_082 LOCOBR082,t1.DIROBR_082 DIROBR082,t1.FECINI_082 FECINI082,t1.FECFIN_082 FECFIN082,t1.TEREXP_082 TEREXP082,t1.ANOEXP_082 ANOEXP082,t1.NUMEXP_082 NUMEXP082,t1.ORDEXP_082 ORDEXP082,t1.FECALT_082 FECALT082,t1.USUALT_082 USUALT082,t1.FECMOD_082 FECMOD082,t1.USUMOD_082 USUMOD082,t1.DESCOBR_082 DESCOBR082,t1.DESOBR_082 DESOBR082,t1.DURPRE_082 DURPRE082,t1.UNITMP_082 UNITMP082,t1.TRBHOM_082 TRBHOM082,t1.TRBMUJ_082 TRBMUJ082,t1.TRBTOT_082 TRBTOT082 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0482S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0482S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterObra, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CODOBRA_082", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 * filterObra Obra jqGridRequestDto JQGridRequestDto Long
	 * 
	 * @param filterObra
	 *            the filter obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	@Override()
	public Long findAllLikeCountJerarquia(Obra filterObra,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0482S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0482S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterObra, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CODOBRA_082", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 * filterObra Obra jqGridRequestDto JQGridRequestDto List<TableRowDto<Obra>>
	 * 
	 * @param filterObra
	 *            the filter obra
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<Obra>> findAllChild(Obra filterObra,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0482S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0482S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterObra, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CODOBRA_082", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(), new RowNumResultSetExtractor<Obra>(
						this.rwMapPK, "CODOBRA_082"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Obra entity.
	 * 
	 * ab0482s00 Obra Bean with the criteria values to filter by. Map created
	 * with two keys key query stores the sql query syntax key params stores the
	 * parameter values to be used in the condition sentence.
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Obra ab0482s00) {

		StringBuilder where = new StringBuilder(ObraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0482s00 != null && ab0482s00.getCodobra082() != null) {
			where.append(" AND t1.CODOBRA_082 = ?");
			params.add(ab0482s00.getCodobra082());
		}
		if (ab0482s00 != null && ab0482s00.getTipobr082() != null) {
			where.append(" AND t1.TIPOBR_082 = ?");
			params.add(ab0482s00.getTipobr082());
		}
		if (ab0482s00 != null && ab0482s00.getIndanx2082() != null) {
			where.append(" AND t1.INDANX2_082 = ?");
			params.add(ab0482s00.getIndanx2082());
		}
		if (ab0482s00 != null && ab0482s00.getApdoanx2082() != null) {
			where.append(" AND t1.APDOANX2_082 = ?");
			params.add(ab0482s00.getApdoanx2082());
		}
		if (ab0482s00 != null && ab0482s00.getDestrab082() != null) {
			where.append(" AND t1.DESTRAB_082 = ?");
			params.add(ab0482s00.getDestrab082());
		}
		if (ab0482s00 != null && ab0482s00.getPrvobr082() != null) {
			where.append(" AND t1.PRVOBR_082 = ?");
			params.add(ab0482s00.getPrvobr082());
		}
		if (ab0482s00 != null && ab0482s00.getMunobr082() != null) {
			where.append(" AND t1.MUNOBR_082 = ?");
			params.add(ab0482s00.getMunobr082());
		}
		if (ab0482s00 != null && ab0482s00.getLocobr082() != null) {
			where.append(" AND t1.LOCOBR_082 = ?");
			params.add(ab0482s00.getLocobr082());
		}
		if (ab0482s00 != null && ab0482s00.getDirobr082() != null) {
			where.append(" AND t1.DIROBR_082 = ?");
			params.add(ab0482s00.getDirobr082());
		}
		if (ab0482s00 != null && ab0482s00.getFecini082() != null) {
			where.append(" AND t1.FECINI_082 = ?");
			params.add(ab0482s00.getFecini082());
		}
		if (ab0482s00 != null && ab0482s00.getFecfin082() != null) {
			where.append(" AND t1.FECFIN_082 = ?");
			params.add(ab0482s00.getFecfin082());
		}
		if (ab0482s00 != null && ab0482s00.getTerexp082() != null) {
			where.append(" AND t1.TEREXP_082 = ?");
			params.add(ab0482s00.getTerexp082());
		}
		if (ab0482s00 != null && ab0482s00.getAnoexp082() != null) {
			where.append(" AND t1.ANOEXP_082 = ?");
			params.add(ab0482s00.getAnoexp082());
		}
		if (ab0482s00 != null && ab0482s00.getNumexp082() != null) {
			where.append(" AND t1.NUMEXP_082 = ?");
			params.add(ab0482s00.getNumexp082());
		}
		if (ab0482s00 != null && ab0482s00.getOrdexp082() != null) {
			where.append(" AND t1.ORDEXP_082 = ?");
			params.add(ab0482s00.getOrdexp082());
		}
		if (ab0482s00 != null && ab0482s00.getFecalt082() != null) {
			where.append(" AND t1.FECALT_082 = ?");
			params.add(ab0482s00.getFecalt082());
		}
		if (ab0482s00 != null && ab0482s00.getUsualt082() != null) {
			where.append(" AND t1.USUALT_082 = ?");
			params.add(ab0482s00.getUsualt082());
		}
		if (ab0482s00 != null && ab0482s00.getFecmod082() != null) {
			where.append(" AND t1.FECMOD_082 = ?");
			params.add(ab0482s00.getFecmod082());
		}
		if (ab0482s00 != null && ab0482s00.getUsumod082() != null) {
			where.append(" AND t1.USUMOD_082 = ?");
			params.add(ab0482s00.getUsumod082());
		}
		if (ab0482s00 != null && ab0482s00.getDescobr082() != null) {
			where.append(" AND t1.DESCOBR_082 = ?");
			params.add(ab0482s00.getDescobr082());
		}
		if (ab0482s00 != null && ab0482s00.getDesobr082() != null) {
			where.append(" AND t1.DESOBR_082 = ?");
			params.add(ab0482s00.getDesobr082());
		}
		if (ab0482s00 != null && ab0482s00.getDurpre082() != null) {
			where.append(" AND t1.DURPRE_082 = ?");
			params.add(ab0482s00.getDurpre082());
		}
		if (ab0482s00 != null && ab0482s00.getUnitmp082() != null) {
			where.append(" AND t1.UNITMP_082 = ?");
			params.add(ab0482s00.getUnitmp082());
		}
		if (ab0482s00 != null && ab0482s00.getTrbhom082() != null) {
			where.append(" AND t1.TRBHOM_082 = ?");
			params.add(ab0482s00.getTrbhom082());
		}
		if (ab0482s00 != null && ab0482s00.getTrbmuj082() != null) {
			where.append(" AND t1.TRBMUJ_082 = ?");
			params.add(ab0482s00.getTrbmuj082());
		}
		if (ab0482s00 != null && ab0482s00.getTrbtot082() != null) {
			where.append(" AND t1.TRBTOT_082 = ?");
			params.add(ab0482s00.getTrbtot082());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Obra entity.
	 * 
	 * ab0482s00 Obra Bean with the criteria values to filter by. startsWith
	 * Boolean Map created with two keys key query stores the sql query syntax
	 * key params stores the parameter values to be used in the condition
	 * sentence.
	 * 
	 * @param ab0482s00
	 *            the ab 0482 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Obra ab0482s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(ObraDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0482s00 != null && ab0482s00.getCodobra082() != null) {
			where.append(" AND t1.CODOBRA_082 = ?");
			params.add(ab0482s00.getCodobra082());
		}
		if (ab0482s00 != null && ab0482s00.getTipobr082() != null) {
			where.append(" AND UPPER(t1.TIPOBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getTipobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getTipobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getIndanx2082() != null) {
			where.append(" AND UPPER(t1.INDANX2_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getIndanx2082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getIndanx2082().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX2_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getApdoanx2082() != null) {
			where.append(" AND UPPER(t1.APDOANX2_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getApdoanx2082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getApdoanx2082().toUpperCase() + "%");
			}
			where.append(" AND t1.APDOANX2_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getDestrab082() != null) {
			where.append(" AND UPPER(t1.DESTRAB_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getDestrab082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getDestrab082().toUpperCase() + "%");
			}
			where.append(" AND t1.DESTRAB_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getPrvobr082() != null) {
			where.append(" AND UPPER(t1.PRVOBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getPrvobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getPrvobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVOBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getMunobr082() != null) {
			where.append(" AND UPPER(t1.MUNOBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getMunobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getMunobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNOBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getLocobr082() != null) {
			where.append(" AND UPPER(t1.LOCOBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getLocobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getLocobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.LOCOBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getDirobr082() != null) {
			where.append(" AND UPPER(t1.DIROBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getDirobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getDirobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.DIROBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getFecini082() != null) {
			where.append(" AND t1.FECINI_082 = ?");
			params.add(ab0482s00.getFecini082());
		}
		if (ab0482s00 != null && ab0482s00.getFecfin082() != null) {
			where.append(" AND t1.FECFIN_082 = ?");
			params.add(ab0482s00.getFecfin082());
		}
		if (ab0482s00 != null && ab0482s00.getTerexp082() != null) {
			where.append(" AND UPPER(t1.TEREXP_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getTerexp082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getTerexp082().toUpperCase() + "%");
			}
			where.append(" AND t1.TEREXP_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getAnoexp082() != null) {
			where.append(" AND UPPER(t1.ANOEXP_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getAnoexp082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getAnoexp082().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOEXP_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getNumexp082() != null) {
			where.append(" AND t1.NUMEXP_082 = ?");
			params.add(ab0482s00.getNumexp082());
		}
		if (ab0482s00 != null && ab0482s00.getOrdexp082() != null) {
			where.append(" AND t1.ORDEXP_082 = ?");
			params.add(ab0482s00.getOrdexp082());
		}
		if (ab0482s00 != null && ab0482s00.getFecalt082() != null) {
			where.append(" AND t1.FECALT_082 = ?");
			params.add(ab0482s00.getFecalt082());
		}
		if (ab0482s00 != null && ab0482s00.getUsualt082() != null) {
			where.append(" AND UPPER(t1.USUALT_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getUsualt082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getUsualt082().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getFecmod082() != null) {
			where.append(" AND t1.FECMOD_082 = ?");
			params.add(ab0482s00.getFecmod082());
		}
		if (ab0482s00 != null && ab0482s00.getUsumod082() != null) {
			where.append(" AND UPPER(t1.USUMOD_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getUsumod082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getUsumod082().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getDescobr082() != null) {
			where.append(" AND UPPER(t1.DESCOBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getDescobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getDescobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCOBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getDesobr082() != null) {
			where.append(" AND UPPER(t1.DESOBR_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getDesobr082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getDesobr082().toUpperCase() + "%");
			}
			where.append(" AND t1.DESOBR_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getDurpre082() != null) {
			where.append(" AND UPPER(t1.DURPRE_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getDurpre082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getDurpre082().toUpperCase() + "%");
			}
			where.append(" AND t1.DURPRE_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getUnitmp082() != null) {
			where.append(" AND UPPER(t1.UNITMP_082) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0482s00.getUnitmp082().toUpperCase() + "%");
			} else {
				params.add("%" + ab0482s00.getUnitmp082().toUpperCase() + "%");
			}
			where.append(" AND t1.UNITMP_082 IS NOT NULL");
		}
		if (ab0482s00 != null && ab0482s00.getTrbhom082() != null) {
			where.append(" AND t1.TRBHOM_082 = ?");
			params.add(ab0482s00.getTrbhom082());
		}
		if (ab0482s00 != null && ab0482s00.getTrbmuj082() != null) {
			where.append(" AND t1.TRBMUJ_082 = ?");
			params.add(ab0482s00.getTrbmuj082());
		}
		if (ab0482s00 != null && ab0482s00.getTrbtot082() != null) {
			where.append(" AND t1.TRBTOT_082 = ?");
			params.add(ab0482s00.getTrbtot082());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
